<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Review extends Model 
{

    protected $table = 'reviews';
    public $timestamps = true;
    protected $fillable = array('order_id', 'client_id', 'comment');

    public function order()
    {
        return $this->hasOne('App\Models\Order');
    }

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function reviewable()
    {
        return $this->morphTo();
    }

}